local greetings={}
local names={"Greetings to","Alpa","B2","BKC","Bjoppen","Bonefish","Bossman","Ca$h","Corpsicle","Dasse","Dubmood","Dunz0r","FSFreak","Fluke73","Frost","Grip","Hevosenliha","Illmidus","Joule","Kavvan","Kwarf","Lisardman","LokasNT","Malmen","Malmix","mAZE","Michan","Mygg","Osterlind","Platon42","Radiant","Shoe","Sinux","Slash","Topatisen","Triace","Vandelay","Vedder","Wasp","Weyland","Wiklund","Wix","Xiny","z-nexx","Zelest","Ziphoid","Znurre","Alcatraz","Birdie\nCrew","Bitbendaz","Censor\nDesign","Dead\nHackers\nSociety","Desire","Facerape","Fairlight","Genesis\nProject","Husvagn\nCrew","Memory\nLeek","Rebels","Scoopex","Syntax\nSociety","Triad","Up Rough"}
local font
local currentIndex=1
local fillProgress=0
local displayTimer=0
local lineSpacingFactor=0.6
local totalDuration=0.439
local fadeDuration=0.058
local longDuration=0.928
local longFadeDuration=0.232
local longDisplayDuration=0.464
local firstNameExtraDelay=1.392
local isFinished=false
local state="fillingIn"
local passedZnurre=false
local AREA_X,AREA_W=235,1686
local AREA_Y,AREA_H=0,1080
local FONT_SIZE=216
local VERTICAL_NUDGE=0
local function split(str,delimiter)
local result={}
for line in str:gmatch("([^"..delimiter.."]+)") do table.insert(result,line) end
return result
end
function greetings.load()
font=love.graphics.newFont("pixelcraft.ttf",FONT_SIZE)
love.graphics.setDefaultFilter("nearest","nearest")
end
function greetings.update(dt)
if isFinished then return end
if state=="fillingIn" then
local currentFadeDuration=passedZnurre and longFadeDuration or fadeDuration
fillProgress=math.min(fillProgress+dt/currentFadeDuration,1)
if fillProgress>=1 then state="displaying";displayTimer=0 end
elseif state=="displaying" then
displayTimer=displayTimer+dt
local currentDisplayDuration
if currentIndex==1 then
currentDisplayDuration=totalDuration-(fadeDuration*2)+firstNameExtraDelay
elseif passedZnurre then
currentDisplayDuration=longDisplayDuration
else
currentDisplayDuration=totalDuration-(fadeDuration*2)
end
if displayTimer>=currentDisplayDuration then state="fillingOut";fillProgress=1 end
elseif state=="fillingOut" then
local currentFadeDuration=passedZnurre and longFadeDuration or fadeDuration
fillProgress=math.max(fillProgress-dt/currentFadeDuration,0)
if fillProgress<=0 then
currentIndex=currentIndex+1
if currentIndex>#names then
isFinished=true;state="displaying";displayTimer=0
else
state="fillingIn";fillProgress=0
if names[currentIndex-1]=="Znurre" then passedZnurre=true end
end end end end
function greetings.draw()
love.graphics.setFont(font)
local currentName=names[math.min(currentIndex,#names)]
local alpha=fillProgress
if currentIndex==1 then
love.graphics.setColor(0.8,0.7,1,alpha)
elseif passedZnurre then
love.graphics.setColor(0.6,0.8,1,alpha)
else
love.graphics.setColor(0.75,0.9,0.75,alpha)
end
greetings.drawMultiLine(currentName)
end
function greetings.drawMultiLine(text)
local lines=split(text,"\n")
local base=font:getHeight()
local step=math.floor(base*lineSpacingFactor+0.5)
local totalHeight=(#lines-1)*step+base
local yStart=math.floor(AREA_Y+(AREA_H-totalHeight)/2+VERTICAL_NUDGE+0.5)
for i,line in ipairs(lines) do
local y=yStart+(i-1)*step
love.graphics.printf(line,AREA_X,y,AREA_W,"center")
end end
return greetings
